-- =======================Messaging event: Period Registration Start=============================================
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='TOOLS_AND_SERVICES');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'EVENT_PERIOD_REGISTRATION_START'); 

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='EVENT_PERIOD_REGISTRATION_START');

INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'Period Registration Start', 'Period Registration Start', 'SYSTEM_SCHEDULE', 0, 0, 1, 0, 1, 0, 0, 'Period Registration Start');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EVENT_PERIOD_REGISTRATION_START_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'EVENT_PERIOD_REGISTRATION_START_RECIPIENTS', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_PERIOD_REGISTRATION_START_RECIPIENTS');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'EVENT_PERIOD_REGISTRATION_START_RECIPIENTS');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_PERIOD_REGISTRATION_START_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EVENT_PERIOD_REGISTRATION_START_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_PERIOD_REGISTRATION_START_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT
    T3.userId AS USER_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
        LEFT OUTER JOIN
    registration_term_setup_detail T7 ON T6.registrationTermSetupDetailId = T7.id
        LEFT OUTER JOIN
    term_wise_period_registration T8 ON T7.id = T8.registrationTermSetupDetailId
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null AND T8.studentPeriodStartDate is not null AND
    DATE(T8.studentPeriodStartDate) = DATE_FORMAT((DATE(NOW())),'%Y-%m-%d')
    AND T1.promotionEnrollmentStatus = 'PENDING' ",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EVENT_PERIOD_REGISTRATION_START_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`,`sqlQuery`, `jsonString`) 
VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT DISTINCT
    T3.userId AS ID,
    T6.programNameToBePrint AS PROGRAM_NAME,
    T4.printName AS STUDENT_NAME,
	T4.printName AS FIRST_NAME,
    T5.batchName AS BATCH_NAME,
    T7.printName AS PERIOD_NAME,
	DATE_FORMAT((T10.studentPeriodStartDate), '%d-%m-%Y') as STUDENT_PERIOD_START_DATE,
	DATE_FORMAT((T10.studentPeriodEndDate), '%d-%m-%Y') as STUDENT_PERIOD_END_DATE,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    T8.academyName AS ACADEMY_NAME
FROM
    program_batch_students T1
        LEFT JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT JOIN
    users T4 ON T3.userId = T4.id
        LEFT JOIN
    batches T5 ON T1.programBatchId = T5.id
        LEFT JOIN
    programs T6 ON T5.programId = T6.id
        LEFT JOIN
    prog_batch_period_config T7 ON T1.progBatchPeriodConfigId = T7.id
        LEFT JOIN
    registration_term_setup_detail T9 ON T7.registrationTermSetupDetailId = T9.id
        LEFT JOIN
    term_wise_period_registration T10 ON T9.id = T10.registrationTermSetupDetailId
        LEFT JOIN
    persons p ON p.id = T3.personId
        LEFT JOIN
    academy_location T8 ON T8.id = T6.academyLocationId
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null AND 
    DATE(T10.studentPeriodStartDate) = DATE_FORMAT((DATE(NOW())),'%Y-%m-%d')
        AND T1.promotionEnrollmentStatus = 'PENDING' AND T3.userId in (namedParams)
GROUP BY T3.userId",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "programNameToBePrint",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PERIOD_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentPeriodStartDate",
            "resultKey": "STUDENT_PERIOD_START_DATE",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "studentPeriodEndDate",
            "resultKey": "STUDENT_PERIOD_END_DATE",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 8
        },
		{
            "id": 10,
            "value": "mobileCountryCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
}');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='EVENT_PERIOD_REGISTRATION_START_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='Period Registration Start');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='EVENT_PERIOD_REGISTRATION_START');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='EVENT_PERIOD_REGISTRATION_START_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Period Registration Start',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,4,NULL,NULL,'Period Registration Start',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Period Registrations are Open','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Hi $recipientData[&quot;STUDENT_NAME&quot;],</p>
			 <p align="left">The registration for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] has been started from
			 $recipientData[&quot;STUDENT_PERIOD_START_DATE&quot;] - $recipientData[&quot;STUDENT_PERIOD_END_DATE&quot;]. Kindly enroll to complete the registrations. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;"><p align="left">$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Period Registrations are Open','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			 <p align="left">Hi $recipientData[&quot;STUDENT_NAME&quot;],</p>
			 <p align="left">The registration for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] has been started from
			 $recipientData[&quot;STUDENT_PERIOD_START_DATE&quot;] - $recipientData[&quot;STUDENT_PERIOD_END_DATE&quot;]. Kindly enroll to complete the registrations. </p>
			</td>
		</tr>
		<tr>
			<td style="padding:20px 20px 20px 20px;"><p align="left">$recipientData[&quot;ACADEMY_NAME&quot;]</p></td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'6',NULL,'Hi $recipientData[&quot;STUDENT_NAME&quot;],  The registration for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] has been started from
			 $recipientData[&quot;STUDENT_PERIOD_START_DATE&quot;] - $recipientData[&quot;STUDENT_PERIOD_END_DATE&quot;].');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+4,@msgtemplateconfigId+1,'2',NULL,'Hi $recipientData[&quot;STUDENT_NAME&quot;],  The registration for $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PERIOD_NAME&quot;] has been started from
			 $recipientData[&quot;STUDENT_PERIOD_START_DATE&quot;] - $recipientData[&quot;STUDENT_PERIOD_END_DATE&quot;].');

SET sql_safe_updates=0;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
update msg_template_config set templateLanguageValue ='English' where templateLanguageValue is null;   
SET sql_safe_updates=1;